/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <string>
#include <iostream>

#include "CalculatorTest.h"

using namespace std;

int main( int argc, const char* argv[] )
{
    std::string fileName;
    bool result = false;

    if (argc > 1)
    {
        fileName = argv[1];
    }
    else
    {
        cerr << "No file name specified" << endl;
        return 1;
    }

    CalculatorTest testor(fileName);

    result = testor.builtInTest();

    result = testor.processTestFile() && result;

    std::string testName("Top Level Result");

    testor.displayTestResult(testName,result);

    if (result)
    {
        return 0;
    }
    else
    {
        return 1;
    }
}
